// config: norepeat

#include "GetObjects.js"
#include "GetPoint.js"

function DoCircularArray()
{
	// First get the objects to array.

	var ui = moi.ui;
	var objectpicker = ui.createObjectPicker();
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;

	// Pick the center point.

	ui.beginUIUpdate();
	ui.hideUI( 'SelectPrompt' );
	ui.hideUI( 'done' );
	ui.showUI( 'CenterPrompt' );
	ui.endUIUpdate();
	
	var pointpicker = ui.createPointPicker();
	if ( !GetPoint( pointpicker ) )
		return;
		
	// Show the UI for adjusting parameters.
	
	// Get the angle mode, either 'fill' (default) or 'step'.
	var AngleMode = 'fill';
	try { AngleMode = moi.command.getOption( 'ArrayCircularAngleMode' ); }
	catch(e) { }
	
	ui.beginUIUpdate();
	ui.hideUI( 'CenterPrompt' );
	ui.showUI( 'done' );
	ui.showUI( 'OptionsPrompt' );
	ui.showUI( 'ArrayOptions' );
	
	if ( AngleMode == 'fill' )
		ui.hideUI( 'StepAngleLabel' );
	else
		ui.hideUI( 'FillAngleLabel' );
	
	ui.endUIUpdate();

	var factory = moi.command.createFactory( 'arraycircular' );
	factory.setInput( 1, pointpicker.ptFrame );
	
	ui.bindUIToInput( 'NumItems', 'value', factory.getInput(2) );
	ui.bindUIToInput( 'Angle', 'value', factory.getInput(3) );
	ui.bindUIToInput( 'VerticalStep', 'value', factory.getInput(4) );
	ui.bindUIToInput( 'RadialStep', 'value', factory.getInput(5) );

	factory.setInput( 0, objects );
	factory.setInput( 6, AngleMode );
	factory.update();

	var commandDialog = ui.commandDialog;
	
	while ( 1 )
	{
		if ( !commandDialog.waitForEvent() )
			return false;
			
		if ( commandDialog.event == 'done' )
			break;
			
		if ( commandDialog.event == 'AngleToggleButton' )
		{
			AngleMode = (AngleMode == 'fill' ? 'step' : 'fill' );
			
			ui.beginUIUpdate();
			ui.showUI( AngleMode == 'fill' ? 'FillAngleLabel' : 'StepAngleLabel' );
			ui.hideUI( AngleMode == 'fill' ? 'StepAngleLabel' : 'FillAngleLabel' );
			ui.endUIUpdate();
			
			moi.command.setOption( 'ArrayCircularAngleMode', AngleMode );


			// Switch the angle value.

			factory.disableUpdate( true );
			
			try
			{
				var NewAngle = factory.getAngleToggleValue();
				ui.commandUI.Angle.value = NewAngle;
				factory.setInput( 3, NewAngle );
			}
			catch(e) {}
			
			factory.disableUpdate( false );

			factory.setInput( 6, AngleMode );
			factory.update();
		}
	}

	factory.commit();
}	

DoCircularArray();
